/*
 * Copyright (C) 2016 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

//******************************************************************************
// Version history:
// 1.0 07/17             Initial version. (Nima Eskandari)
// 1.1 07/17             Added Comments. (Nima Eskandari)
//----------------------------------------------------------------------------
//   Designed 2017 by Texas Instruments
//
//   Nima Eskandari
//   Texas Instruments Inc.
//   August 2017
//   Built with CCS Version: Code Composer Studio v7
//******************************************************************************

#include <stdio.h>
#include <stdbool.h>
#include <stddef.h>
#include <termios.h>
#include <time.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <uart_if.h>
#include <pinmux.h>
#include <gpio_if.h>
#include <config.h>
#include <utils.h>
#include <bsl.h>
#include <time.h>

//*****************************************************************************
// MSP430FR Image to use ******************************************************
//*****************************************************************************

#include <image/msp430fr_image.h>

//*****************************************************************************
// Program the MSP430FR with the specified image ******************************
//*****************************************************************************
bool ProgramMSP430()
{
	bool numberOfErrors = 0;
	bool result = true;
	uint16_t section = 0;
	uint8_t * framStartOfData = 0;

	for (section = 0; section < fram_sections; section++)
	{
        printf("\n\n****Section: %d****\n\n", section);
        printf("Address: 0x%X\n", fram_address[section]);
        if (section == 0)
        {
            framStartOfData = fram;
        }
        else
        {
            framStartOfData = framStartOfData + fram_length_of_sections[section - 1];
        }


        result = WriteLargeDataToMemory(fram_address[section], fram_length_of_sections[section], framStartOfData);
        if (!result)
        {
        	printf("Write Large Data To Memory failed\n");
        	return false;
        }
        else
        {
        	printf("Write Large Data To Memory successful\n");
        }

	}

	if (numberOfErrors != 0)
	{
		return false;
	}
	return true;
}

#define MAX_RETRY	5

int main()
{
	bool result = true;
	UART_Initialize();
	PinMuxConfig();
	uint8_t retry = MAX_RETRY;

	while (retry)
	{
		printf("\n\n*****New Attempt*****\n\n");
		BSLEntrySequence();
		MsDelay(100);
		//UART_ReadByte(); //Dummy read to empty buffer
		result = WritePasswordDefault();
		if (!result)
		{
			printf("Write password failed\n");
			retry --;
			continue;
		}
		printf("Write Password was successful\n");
		uint8_t deviceIDBytes[2] = {0};
		result = ReadMemory(0x1A04, 2, deviceIDBytes);
		if (!result)
		{
			printf("Device ID read failed\n");
			retry --;
			continue;
		}
		uint16_t deviceID = deviceIDBytes[0] << 8 | deviceIDBytes[1];
		printf("Device ID: 0x%X\n", deviceID);

		result = ProgramMSP430();
		if (!result)
		{
			printf("\nMSP430 programming failed\n");
			retry --;
			continue;
		}

		printf("\nMSP430 programmed successfully\n");
		UART_Close();
		Reset();
		printf("Device is reset\n");
		return 0;
	}

	UART_Close();
	printf("Max retries exceeded\n");
	return 1;
}


